import { StarXpandCommand } from "star-io10-web";

export class LabelSample11_For203dpi_ExpirationDate_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 35.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    72.0,
                    35.0,
                  ),
                )
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(3, 3),
                )
                .styleVerticalPositionTo(5.0)
                .actionPrintText("Expiration Date:\n")
                .styleHorizontalPositionTo(2.0)
                .styleVerticalPositionBy(10.0)
                .styleUnderLine(true)
                .actionPrintText(
                  "${expiration_date}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    15,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "expiration_date" : "12/22/2023"
}`,
    );
  }
}
